import "core-js/modules/es.promise.js";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

import webpack, { ProgressPlugin } from 'webpack';
import webpackDevMiddleware from 'webpack-dev-middleware';
import { logger } from '@storybook/node-logger';
import { useProgressReporting, checkWebpackVersion } from '@storybook/core-common';
import { pathExists } from 'fs-extra';
import express from 'express';
import { getManagerWebpackConfig } from './manager-config';
import { clearManagerCache, useManagerCache } from '../utils/manager-cache';
import { getPrebuiltDir } from '../utils/prebuilt-manager';
var compilation;
var reject;

var checkWebpackVersion4 = function (webpackInstance) {
  return checkWebpackVersion(webpackInstance, '4.x', 'manager-builder');
};

export var getConfig = getManagerWebpackConfig;
export var executor = {
  get: webpack
};
export var makeStatsFromError = function (err) {
  return {
    hasErrors: function () {
      return true;
    },
    hasWarnings: function () {
      return false;
    },
    toJson: function () {
      return {
        warnings: [],
        errors: [err]
      };
    }
  };
};
export var start = async function ({
  startTime: startTime,
  options: options,
  router: router
}) {
  var _config$output;

  checkWebpackVersion4(executor.get);
  var prebuiltDir = await getPrebuiltDir(options);
  var config = await getConfig(options);

  if (options.cache) {
    if (options.managerCache) {
      var _await$Promise$all = await Promise.all([// must run even if outputDir doesn't exist, otherwise the 2nd run won't use cache
      useManagerCache(options.cache, config), pathExists(options.outputDir)]),
          _await$Promise$all2 = _slicedToArray(_await$Promise$all, 2),
          useCache = _await$Promise$all2[0],
          hasOutput = _await$Promise$all2[1];

      if (useCache && hasOutput && !options.smokeTest) {
        logger.info('=> Using cached manager'); // Manager static files

        router.use('/', express.static(prebuiltDir || options.outputDir));
        return;
      }
    } else if (!options.smokeTest && (await clearManagerCache(options.cache))) {
      logger.info('=> Cleared cached manager config');
    }
  }

  var compiler = executor.get(config);

  if (!compiler) {
    var err = `${config.name}: missing webpack compiler at runtime!`;
    logger.error(err); // eslint-disable-next-line consistent-return

    return {
      bail: bail,
      totalTime: process.hrtime(startTime),
      stats: makeStatsFromError(err)
    };
  }

  var _await$useProgressRep = await useProgressReporting(router, startTime, options),
      handler = _await$useProgressRep.handler,
      modulesCount = _await$useProgressRep.modulesCount;

  new ProgressPlugin({
    handler: handler,
    modulesCount: modulesCount
  }).apply(compiler);
  var middlewareOptions = {
    publicPath: (_config$output = config.output) === null || _config$output === void 0 ? void 0 : _config$output.publicPath,
    writeToDisk: true
  };
  compilation = webpackDevMiddleware(compiler, middlewareOptions);
  router.use(compilation);
  var stats = await new Promise(function (ready, stop) {
    compilation.waitUntilValid(ready);
    reject = stop;
  });

  if (!stats) {
    throw new Error('no stats after building preview');
  } // eslint-disable-next-line consistent-return


  return {
    bail: bail,
    stats: stats,
    totalTime: process.hrtime(startTime)
  };
};
export var bail = function (e) {
  if (reject) {
    reject();
  }

  if (process) {
    try {
      compilation.close();
      logger.warn('Force closed preview build');
    } catch (err) {
      logger.warn('Unable to close preview build!');
    }
  }

  throw e;
};
export var build = async function ({
  options: options,
  startTime: startTime
}) {
  logger.info('=> Compiling manager..');
  checkWebpackVersion4(executor.get);
  var config = await getConfig(options);
  var statsOptions = typeof config.stats === 'boolean' ? 'minimal' : config.stats;
  var compiler = executor.get(config);

  if (!compiler) {
    var err = `${config.name}: missing webpack compiler at runtime!`;
    logger.error(err);
    return Promise.resolve(makeStatsFromError(err));
  }

  return new Promise(function (succeed, fail) {
    compiler.run(function (error, stats) {
      if (error || !stats || stats.hasErrors()) {
        logger.error('=> Failed to build the manager');

        if (error) {
          logger.error(error.message);
        }

        if (stats && (stats.hasErrors() || stats.hasWarnings())) {
          var _stats$toJson = stats.toJson(statsOptions),
              warnings = _stats$toJson.warnings,
              errors = _stats$toJson.errors;

          errors.forEach(function (e) {
            return logger.error(e);
          });
          warnings.forEach(function (e) {
            return logger.error(e);
          });
        }

        process.exitCode = 1;
        fail(error || stats);
      } else {
        var _statsData$warnings;

        logger.trace({
          message: '=> Manager built',
          time: process.hrtime(startTime)
        });
        var statsData = stats.toJson(typeof statsOptions === 'string' ? statsOptions : _objectSpread(_objectSpread({}, statsOptions), {}, {
          warnings: true
        }));
        statsData === null || statsData === void 0 ? void 0 : (_statsData$warnings = statsData.warnings) === null || _statsData$warnings === void 0 ? void 0 : _statsData$warnings.forEach(function (e) {
          return logger.warn(e);
        });
        succeed(stats);
      }
    });
  });
};
export var corePresets = [];
export var overridePresets = [];