import "core-js/modules/es.promise.js";
import path from 'path';
import { getInterpretedFile, serverRequire } from '@storybook/core-common';
var DEFAULT_WEBPACK = 'webpack4';
export async function getPreviewBuilder(configDir) {
  var main = path.resolve(configDir, 'main');
  var mainFile = getInterpretedFile(main);

  var _ref = mainFile ? serverRequire(mainFile) : {
    core: null
  },
      core = _ref.core;

  var builder = (core === null || core === void 0 ? void 0 : core.builder) || DEFAULT_WEBPACK;
  var previewBuilder = await import(`@storybook/builder-${builder}`);
  return previewBuilder;
}