"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassPath = void 0;
const path = require("path");
function canonicalize(rawClasspath) {
    let sanitisedClassPath = rawClasspath.trim();
    while (sanitisedClassPath.startsWith(path.delimiter)) {
        sanitisedClassPath = sanitisedClassPath.slice(1);
    }
    while (sanitisedClassPath.endsWith(path.delimiter)) {
        sanitisedClassPath = sanitisedClassPath.slice(0, -1);
    }
    return sanitisedClassPath;
}
class ClassPath {
    constructor(classPath) {
        this.value = canonicalize(classPath);
    }
    isEmpty() {
        return this.value.length === 0;
    }
    concat(other) {
        const elements = this.value.split(path.delimiter);
        const otherElements = other.value.split(path.delimiter);
        const newElements = Array.from(new Set(elements.concat(otherElements)).values());
        return new ClassPath(newElements.join(path.delimiter));
    }
    toString() {
        return this.value;
    }
}
exports.ClassPath = ClassPath;
//# sourceMappingURL=classpath.js.map