"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddonPanel = void 0;

var _react = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var usePrevious = function usePrevious(value) {
  var ref = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    // happens after return
    ref.current = value;
  }, [value]);
  return ref.current;
};

var useUpdate = function useUpdate(update, value) {
  var previousValue = usePrevious(value);
  return update ? value : previousValue;
};

var AddonPanel = function AddonPanel(_ref) {
  var active = _ref.active,
      children = _ref.children;
  return (
    /*#__PURE__*/
    // the transform is to prevent a bug where the content would be invisible
    // the hidden attribute is an valid html element that's both accessible and works to visually hide content
    _react.default.createElement("div", {
      hidden: !active,
      style: {
        transform: 'translateX(0px)'
      }
    }, useUpdate(active, children))
  );
};

exports.AddonPanel = AddonPanel;
AddonPanel.displayName = "AddonPanel";