import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import BellIcon from '@patternfly/react-icons/dist/js/icons/bell-icon';
import CheckCircleIcon from '@patternfly/react-icons/dist/js/icons/check-circle-icon';
import ExclamationCircleIcon from '@patternfly/react-icons/dist/js/icons/exclamation-circle-icon';
import ExclamationTriangleIcon from '@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon';
import InfoCircleIcon from '@patternfly/react-icons/dist/js/icons/info-circle-icon';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer';
import a11yStyles from '@patternfly/react-styles/css/utilities/Accessibility/accessibility';
export const variantIcons = {
  success: CheckCircleIcon,
  danger: ExclamationCircleIcon,
  warning: ExclamationTriangleIcon,
  info: InfoCircleIcon,
  default: BellIcon
};
export const NotificationDrawerListItemHeader = (_ref) => {
  let {
    children,
    className = '',
    icon = null,
    srTitle,
    title,
    variant = 'default'
  } = _ref,
      props = _objectWithoutProperties(_ref, ["children", "className", "icon", "srTitle", "title", "variant"]);

  const Icon = variantIcons[variant];
  return React.createElement(React.Fragment, null, React.createElement("div", _extends({}, props, {
    className: css(styles.notificationDrawerListItemHeader, className)
  }), React.createElement("span", {
    className: css(styles.notificationDrawerListItemHeaderIcon)
  }, icon ? icon : React.createElement(Icon, null)), React.createElement("h2", {
    className: css(styles.notificationDrawerListItemHeaderTitle)
  }, srTitle && React.createElement("span", {
    className: css(a11yStyles.screenReader)
  }, srTitle), title)), children && React.createElement("div", {
    className: css(styles.notificationDrawerListItemAction)
  }, children));
};
NotificationDrawerListItemHeader.propTypes = {
  children: _pt.node,
  className: _pt.string,
  icon: _pt.node,
  srTitle: _pt.string,
  title: _pt.string.isRequired,
  variant: _pt.oneOf(['success', 'danger', 'warning', 'info', 'default'])
};
//# sourceMappingURL=NotificationDrawerListItemHeader.js.map