"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readJSON = exports.Cache = void 0;
//This is our own implementation of flat-cache without the use of flattened as we do not need cicular JSON support
//and the executable for flattened was broken
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
class Cache {
    constructor(docId, cacheDir) {
        this.visited = {};
        this.persisted = {};
        this.pathToFile = '';
        this.pathToFile = cacheDir ? path_1.default.resolve(cacheDir, docId) : path_1.default.resolve(__dirname, '../.cache/', docId);
        if (fs_1.default.existsSync(this.pathToFile)) {
            this.persisted = tryParse(this.pathToFile, {});
        }
    }
    save(noPrune = false) {
        !noPrune && this.prune();
        writeJSON(this.pathToFile, this.persisted);
    }
    getKey(key) {
        this.visited[key] = true;
        return this.persisted[key];
    }
    setKey(key, value) {
        this.visited[key] = true;
        this.persisted[key] = value;
    }
    prune() {
        let obj = {};
        const keys = Object.keys(this.visited);
        // no keys visited for either get or set value
        if (keys.length === 0) {
            return;
        }
        keys.forEach(key => {
            obj[key] = this.persisted[key];
        });
        this.visited = {};
        this.persisted = obj;
    }
}
exports.Cache = Cache;
function writeJSON(filePath, data) {
    fs_1.default.mkdirSync(path_1.default.dirname(filePath), {
        recursive: true,
    });
    fs_1.default.writeFileSync(filePath, JSON.stringify(data));
}
function tryParse(filePath, defaultValue) {
    let result;
    try {
        result = readJSON(filePath);
    }
    catch (ex) {
        result = defaultValue;
    }
    return result;
}
function readJSON(filePath) {
    return JSON.parse(fs_1.default.readFileSync(filePath, {
        encoding: 'utf8',
    }));
}
exports.readJSON = readJSON;
//# sourceMappingURL=cache.js.map