/// <reference types="node" />
import { EventEmitter } from 'events';
import { AnalysisResponseProgress } from './http';
import { ISupportedFiles } from './interfaces/files.interface';
declare enum CUSTOM_EVENTS {
    supportedFilesLoaded = "supportedFilesLoaded",
    scanFilesProgress = "scanFilesProgress",
    createBundleProgress = "createBundleProgress",
    uploadBundleProgress = "uploadBundleProgress",
    analyseProgress = "analyseProgress",
    apiRequestLog = "apiRequestLog",
    error = "error"
}
export declare class EmitterDC extends EventEmitter {
    events: typeof CUSTOM_EVENTS;
    supportedFilesLoaded(data: ISupportedFiles | null): void;
    scanFilesProgress(processed: number): void;
    createBundleProgress(processed: number, total: number): void;
    uploadBundleProgress(processed: number, total: number): void;
    analyseProgress(data: AnalysisResponseProgress): void;
    sendError(error: Error): void;
    apiRequestLog(message: string): void;
}
declare const emitter: EmitterDC;
export default emitter;
