"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManifestFileNotValid = exports.getDependencyNamesFrom = exports.pkgInfoFrom = void 0;
const toml = require("toml");
function pkgInfoFrom(manifestFileContents) {
    let manifest;
    try {
        manifest = toml.parse(manifestFileContents);
        return {
            name: manifest.tool.poetry.name,
            version: manifest.tool.poetry.version,
        };
    }
    catch (_a) {
        throw new ManifestFileNotValid();
    }
}
exports.pkgInfoFrom = pkgInfoFrom;
function getDependencyNamesFrom(manifestFileContents, includeDevDependencies) {
    var _a;
    const manifest = toml.parse(manifestFileContents);
    if (!((_a = manifest.tool) === null || _a === void 0 ? void 0 : _a.poetry)) {
        throw new ManifestFileNotValid();
    }
    const dependencies = dependenciesFrom(manifest);
    const devDependencies = includeDevDependencies
        ? devDependenciesFrom(manifest)
        : [];
    return [...dependencies, ...devDependencies].filter((pkgName) => pkgName != 'python');
}
exports.getDependencyNamesFrom = getDependencyNamesFrom;
function devDependenciesFrom(manifest) {
    return Object.keys(manifest.tool.poetry['dev-dependencies'] || []);
}
function dependenciesFrom(manifest) {
    return Object.keys(manifest.tool.poetry.dependencies || []);
}
class ManifestFileNotValid extends Error {
    constructor() {
        super('pyproject.toml is not a valid poetry file.');
        this.name = 'ManifestFileNotValid';
    }
}
exports.ManifestFileNotValid = ManifestFileNotValid;
//# sourceMappingURL=manifest-parser.js.map