"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDevDependency = void 0;
/*
 * A dependency can be a limited to more than one environment (i.e. :dev and :test)
 * The logic to decide the scope (dev/prod):
 * If the dependency is not whitelisted, or if :prod is in the `only` whitelist, we consider it as a prod dependency
 * Otherwise it's a dev dependency.
 * */
function isDevDependency(options) {
    if (!options || !options.only)
        return false;
    const envs = Array.isArray(options.only) ? options.only : [options.only];
    return envs.every((env) => env !== 'prod');
}
exports.isDevDependency = isDevDependency;
//# sourceMappingURL=is-dev-dependency.js.map