declare type AppPath = string;
export declare type MixJsonResult = {
    manifest: Manifest;
    lock: [Lock];
    apps?: Record<AppPath, Manifest>;
    parent_umbrella_manifest?: Manifest;
};
export declare type Manifest = {
    app: string;
    version: string;
    elixir: string;
    start_permanent: boolean;
    deps: TopLevelDeps;
    description: string;
    package: any;
    name: string;
    module_name: string;
    apps_path?: string;
};
declare type Lock = Record<DepName, [PackageManager, DepName, DepVersion, DepHash, [BuildTool], Dependency[], Repo, DepHash2]>;
export declare type LockDepMap = Record<DepName, LockDep>;
export declare type LockDepBase = {
    name: DepName;
    version: DepVersion;
    dependencies?: Dependency[];
};
declare type LockDep = LockDepBase & {
    packageManager: PackageManager;
    hash: DepHash;
    dependencies: Dependency[];
};
declare type Dependency = [DepName, DepVersionSpec, {
    hex: DepName;
    repo: Repo;
    optional: boolean;
}];
declare type PackageManager = 'hex';
declare type Compiler = 'mix' | 'rebar' | 'make';
declare type Manager = 'mix' | 'rebar' | 'rebar3' | 'make';
declare type BuildTool = 'mix';
declare type DepName = string;
declare type DepVersion = string;
declare type DepVersionSpec = string;
declare type DepHash = string;
declare type DepHash2 = string;
declare type Repo = 'hexpm';
declare type Environment = 'dev' | 'test' | 'prod';
declare type DependencyDefinitionOptions = {
    app?: false | 'read';
    env?: string;
    compile?: Compiler;
    optional?: boolean;
    only?: Environment | Environment[];
    override?: boolean;
    manager?: Manager;
    runtime?: boolean;
    system_env?: boolean;
};
export declare type GitOptions = {
    git?: string;
    github?: string;
    ref?: string;
    branch?: string;
    tag?: string;
    submodules?: string;
    sparse?: string;
};
export declare type PathOptions = {
    path?: string;
    in_umbrella?: boolean;
};
export declare type TopLevelDepOptions = DependencyDefinitionOptions & GitOptions & PathOptions;
declare type TopLevelDepsMap = Record<DepName, DepVersionSpec | TopLevelDepOptions | [DepVersionSpec?, TopLevelDepOptions?]>;
declare type TopLevelDep = [DepName, DepVersionSpec?, TopLevelDepOptions?];
export declare type TopLevelDepsArr = TopLevelDep[];
declare type TopLevelDeps = TopLevelDepsArr | TopLevelDepsMap;
export {};
