/**
 * getAuthTokenForEndpoint attempts to retrieve a token for an unauthorized endpoint.
 * It will make a request to the endpoint and in case it returns an Unauthorized (401)
 * response code with the 'www-Authenticate' header, it will make a consecutive call according
 * to the details within this header.
 * More info: https://docs.docker.com/registry/spec/auth/token/#how-to-authenticate
 * @param registryBase - the container registry base URL
 * @param endpoint - the endpoint to which we would like to make the request
 * @param username - the username for authentication
 * @param password - the password for authentication
 * @param reqOptions - http request options
 * @returns an auth token string if authentication succeeded or null if
 * authorization is not required/not bases on bearer token
 * @throws an error if http error status code is not 401
 */
export declare function getAuthTokenForEndpoint(registryBase: string, endpoint: string, username: string, password: string, reqOptions?: any): Promise<string | null>;
