import { EntityToFix, WithUserMessage } from '../../../types';
interface Supported {
    supported: true;
}
interface NotSupported {
    supported: false;
    reason: string;
}
export declare function projectTypeSupported(res: Supported | NotSupported): res is Supported;
export declare function isSupported(entity: EntityToFix): Promise<Supported | NotSupported>;
export declare function partitionByFixable(entities: EntityToFix[]): Promise<{
    skipped: Array<WithUserMessage<EntityToFix>>;
    fixable: EntityToFix[];
}>;
export {};
