"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.containsRequireDirective = void 0;
/* Requires like -r, -c are not supported at the moment, as multiple files
 * would have to be identified and fixed together
 * https://pip.pypa.io/en/stable/reference/pip_install/#options
 */
async function containsRequireDirective(requirementsTxt) {
    const allMatches = [];
    const REQUIRE_PATTERN = new RegExp(/^[^\S\n]*-(r|c)\s+(.+)/, 'gm');
    const matches = getAllMatchedGroups(REQUIRE_PATTERN, requirementsTxt);
    for (const match of matches) {
        if (match && match.length > 1) {
            allMatches.push(match);
        }
    }
    return { containsRequire: allMatches.length > 0, matches: allMatches };
}
exports.containsRequireDirective = containsRequireDirective;
function getAllMatchedGroups(re, str) {
    const groups = [];
    let match;
    // tslint:disable-next-line:no-conditional-assignment
    while ((match = re.exec(str))) {
        groups.push(match);
    }
    return groups;
}
//# sourceMappingURL=contains-require-directive.js.map