import { DepGraphData } from '@snyk/dep-graph';
import { CustomError } from './lib/errors/custom-error';
export interface GitTarget {
    remoteUrl: string;
    branch: string;
}
export interface ContainerTarget {
    image: string;
}
export interface ScanResult {
    readonly identity: Identity;
    readonly facts: Facts[];
    readonly name?: string;
    readonly policy?: string;
    readonly target?: GitTarget | ContainerTarget;
}
export interface Identity {
    type: string;
    targetFile?: string;
    args?: {
        [key: string]: string;
    };
}
export interface Facts {
    type: string;
    data: any;
}
export interface TestResult {
    readonly issues: Issue[];
    readonly issuesData: IssuesData;
    readonly depGraphData: DepGraphData;
    readonly remediation?: RemediationChanges;
}
export interface Issue {
    pkgName: string;
    pkgVersion?: string;
    issueId: string;
    fixInfo: FixInfo;
}
interface UpgradePath {
    path: UpgradePathItem[];
}
export interface FixInfo {
    upgradePaths?: UpgradePath[];
    isPatchable?: boolean;
    nearestFixedInVersion?: string;
}
interface UpgradePathItem {
    name: string;
    version: string;
    newVersion?: string;
    isDropped?: boolean;
}
export interface IssuesData {
    [issueId: string]: {
        id: string;
        severity: SEVERITY;
        title: string;
    };
}
export interface Upgrade {
    upgradeTo: string;
}
export interface UpgradeVulns extends Upgrade {
    vulns: string[];
}
export interface UpgradeRemediation extends UpgradeVulns {
    upgrades: string[];
}
export interface PatchRemediation {
    paths: PatchObject[];
}
export interface DependencyUpdates {
    [from: string]: UpgradeRemediation;
}
export interface PinRemediation extends UpgradeVulns {
    isTransitive: boolean;
}
export interface DependencyPins {
    [name: string]: PinRemediation;
}
export interface RemediationChanges {
    unresolved: IssueData[];
    upgrade: DependencyUpdates;
    patch: {
        [name: string]: PatchRemediation;
    };
    ignore: unknown;
    pin: DependencyPins;
}
export interface IssueData {
    id: string;
    packageName: string;
    version: string;
    moduleName?: string;
    below: string;
    semver: {
        vulnerable: string | string[];
        vulnerableHashes?: string[];
        vulnerableByDistro?: {
            [distroNameAndVersion: string]: string[];
        };
    };
    patches: Patch[];
    isNew: boolean;
    description: string;
    title: string;
    severity: SEVERITY;
    fixedIn: string[];
    legalInstructions?: string;
    reachability?: REACHABILITY;
}
interface Patch {
    version: string;
    id: string;
    urls: string[];
    modificationTime: string;
}
export declare enum REACHABILITY {
    FUNCTION = "function",
    PACKAGE = "package",
    NOT_REACHABLE = "not-reachable",
    NO_INFO = "no-info"
}
export interface PatchObject {
    [name: string]: {
        patched: string;
    };
}
export declare enum SEVERITY {
    LOW = "low",
    MEDIUM = "medium",
    HIGH = "high",
    CRITICAL = "critical"
}
export declare type SupportedScanTypes = 'pip';
export interface Workspace {
    path: string;
    readFile: (path: string) => Promise<string>;
    writeFile: (path: string, content: string) => Promise<void>;
}
export interface EntityToFix {
    readonly workspace: Workspace;
    readonly scanResult: ScanResult;
    readonly testResult: TestResult;
    readonly options: CliTestOptions;
}
export interface PythonTestOptions {
    command?: string;
}
export declare type CliTestOptions = PythonTestOptions;
export interface WithError<Original> {
    original: Original;
    error: CustomError;
    tip?: string;
}
export interface WithFixChangesApplied<Original> {
    original: Original;
    changes: FixChangesSummary[];
}
export interface WithUserMessage<Original> {
    original: Original;
    userMessage: string;
}
export declare type FixChangesSummary = FixChangesSuccess | FixChangesError;
interface FixChangesSuccess {
    success: true;
    userMessage: string;
    issueIds: string[];
    from?: string;
    to?: string;
}
interface FixChangesError {
    success: false;
    userMessage: string;
    reason: string;
    tip?: string;
    issueIds: string[];
    from?: string;
    to?: string;
}
export interface ErrorsByEcoSystem {
    [ecosystem: string]: {
        originals: EntityToFix[];
        userMessage: string;
    };
}
export interface FixOptions {
    dryRun?: boolean;
    quiet?: boolean;
    stripAnsi?: boolean;
}
export interface FixedMeta {
    fixed: number;
    failed: number;
}
export {};
