import { Dep, DepTreeDep, Lockfile, LockfileParser, LockfileType, ManifestFile, PkgTree } from './';
export interface PackageLockDeps {
    [depName: string]: PackageLockDep;
}
export interface PackageLockDep {
    version: string;
    requires?: {
        [depName: string]: string;
    };
    dependencies?: PackageLockDeps;
    dev?: boolean;
}
export interface DepMap {
    [path: string]: DepMapItem;
}
export interface DepMapItem extends DepTreeDep {
    requires: string[];
}
export declare abstract class LockParserBase implements LockfileParser {
    protected type: LockfileType;
    protected treeSizeLimit: number;
    protected pathDelimiter: string;
    constructor(type: LockfileType, treeSizeLimit: number);
    abstract parseLockFile(lockFileContents: string): Lockfile;
    getDependencyTree(manifestFile: ManifestFile, lockfile: Lockfile, includeDev?: boolean, strict?: boolean): Promise<PkgTree>;
    private setDevDepRec;
    private removeCycle;
    private cloneAcyclicNodeEdges;
    private cloneNodeWithoutEdges;
    private createGraphOfDependencies;
    private findDepsPath;
    private createDepTrees;
    protected getDepMap(lockfile: Lockfile): DepMap;
    protected getDepTreeKey(dep: Dep): string;
}
