"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var functionExpression = /[\s]*([a-z-]+)[\s]*\([\s]*([^\)]+)[\s]*\)[\s]*/i;
var floatExpression = /^(\-?\d+\.?\d{0,5})/;
exports.formatUnit = function (unit) { return function (val) { return (val + unit); }; };
exports.toFloat = parseFloat;
function ensurePercent(value) {
    return typeof value === 'number'
        ? value
        : exports.toFloat(value) * .01;
}
exports.ensurePercent = ensurePercent;
function formatPercent(value) {
    return (formatFloat(value * 100)) + '%';
}
exports.formatPercent = formatPercent;
/**
 * Returns a number formatted to a max number of 5 decimal places
 */
function formatFloat(n) {
    return floatExpression.exec(n.toString())[1];
}
exports.formatFloat = formatFloat;
function ensureLength(value) {
    if (value === null || value === undefined) {
        return undefined;
    }
    // convert to number
    var number = +value;
    // validate conversion worked (NaN will not equal NaN)
    if (number === number) {
        return value + 'px';
    }
    return value;
}
exports.ensureLength = ensureLength;
function parseCSSFunction(stringValue) {
    var matches = functionExpression.exec(stringValue);
    if (!matches || !matches.length) {
        return undefined;
    }
    return [matches[1]].concat(matches[2].split(','));
}
exports.parseCSSFunction = parseCSSFunction;
function cssFunction(functionName, params) {
    var parts = Array.prototype.join.call(params, ',');
    return functionName + "(" + parts + ")";
}
exports.cssFunction = cssFunction;
function createFunction(name) {
    return (function () {
        return cssFunction(name, arguments);
    });
}
exports.createFunction = createFunction;
