"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toFilename = exports.convertPath = exports.ppath = exports.npath = exports.Filename = exports.PortablePath = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
var PathType;
(function (PathType) {
    PathType[PathType["File"] = 0] = "File";
    PathType[PathType["Portable"] = 1] = "Portable";
    PathType[PathType["Native"] = 2] = "Native";
})(PathType || (PathType = {}));
exports.PortablePath = {
    root: `/`,
    dot: `.`,
};
exports.Filename = {
    nodeModules: `node_modules`,
    manifest: `package.json`,
    lockfile: `yarn.lock`,
    pnpJs: `.pnp.js`,
    rc: `.yarnrc.yml`,
};
exports.npath = Object.create(path_1.default);
exports.ppath = Object.create(path_1.default.posix);
exports.npath.cwd = () => process.cwd();
exports.ppath.cwd = () => toPortablePath(process.cwd());
exports.ppath.resolve = (...segments) => {
    if (segments.length > 0 && exports.ppath.isAbsolute(segments[0])) {
        return path_1.default.posix.resolve(...segments);
    }
    else {
        return path_1.default.posix.resolve(exports.ppath.cwd(), ...segments);
    }
};
const contains = function (pathUtils, from, to) {
    from = pathUtils.normalize(from);
    to = pathUtils.normalize(to);
    if (from === to)
        return `.`;
    if (!from.endsWith(pathUtils.sep))
        from = (from + pathUtils.sep);
    if (to.startsWith(from)) {
        return to.slice(from.length);
    }
    else {
        return null;
    }
};
exports.npath.fromPortablePath = fromPortablePath;
exports.npath.toPortablePath = toPortablePath;
exports.npath.contains = (from, to) => contains(exports.npath, from, to);
exports.ppath.contains = (from, to) => contains(exports.ppath, from, to);
const WINDOWS_PATH_REGEXP = /^([a-zA-Z]:.*)$/;
const UNC_WINDOWS_PATH_REGEXP = /^\\\\(\.\\)?(.*)$/;
const PORTABLE_PATH_REGEXP = /^\/([a-zA-Z]:.*)$/;
const UNC_PORTABLE_PATH_REGEXP = /^\/unc\/(\.dot\/)?(.*)$/;
// Path should look like "/N:/berry/scripts/plugin-pack.js"
// And transform to "N:\berry\scripts\plugin-pack.js"
function fromPortablePath(p) {
    if (process.platform !== `win32`)
        return p;
    if (p.match(PORTABLE_PATH_REGEXP))
        p = p.replace(PORTABLE_PATH_REGEXP, `$1`);
    else if (p.match(UNC_PORTABLE_PATH_REGEXP))
        p = p.replace(UNC_PORTABLE_PATH_REGEXP, (match, p1, p2) => `\\\\${p1 ? `.\\` : ``}${p2}`);
    else
        return p;
    return p.replace(/\//g, `\\`);
}
// Path should look like "N:/berry/scripts/plugin-pack.js"
// And transform to "/N:/berry/scripts/plugin-pack.js"
function toPortablePath(p) {
    if (process.platform !== `win32`)
        return p;
    if (p.match(WINDOWS_PATH_REGEXP))
        p = p.replace(WINDOWS_PATH_REGEXP, `/$1`);
    else if (p.match(UNC_WINDOWS_PATH_REGEXP))
        p = p.replace(UNC_WINDOWS_PATH_REGEXP, (match, p1, p2) => `/unc/${p1 ? `.dot/` : ``}${p2}`);
    return p.replace(/\\/g, `/`);
}
function convertPath(targetPathUtils, sourcePath) {
    return (targetPathUtils === exports.npath ? fromPortablePath(sourcePath) : toPortablePath(sourcePath));
}
exports.convertPath = convertPath;
function toFilename(filename) {
    if (exports.npath.parse(filename).dir !== `` || exports.ppath.parse(filename).dir !== ``)
        throw new Error(`Invalid filename: "${filename}"`);
    return filename;
}
exports.toFilename = toFilename;
