"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertLegacyTestResultToFixEntities = void 0;
const fs = require("fs");
const pathLib = require("path");
const convert_legacy_test_result_to_new_1 = require("./convert-legacy-test-result-to-new");
const convert_legacy_test_result_to_scan_result_1 = require("./convert-legacy-test-result-to-scan-result");
function convertLegacyTestResultToFixEntities(testResults, root, options) {
    if (testResults instanceof Error) {
        return [];
    }
    const oldResults = Array.isArray(testResults) ? testResults : [testResults];
    return oldResults.map((res) => ({
        options,
        workspace: {
            path: root,
            readFile: async (path) => {
                return fs.readFileSync(pathLib.resolve(root, path), 'utf8');
            },
            writeFile: async (path, content) => {
                return fs.writeFileSync(pathLib.resolve(root, path), content, 'utf8');
            },
        },
        scanResult: convert_legacy_test_result_to_scan_result_1.convertLegacyTestResultToScanResult(res),
        testResult: convert_legacy_test_result_to_new_1.convertLegacyTestResultToNew(res),
    }));
}
exports.convertLegacyTestResultToFixEntities = convertLegacyTestResultToFixEntities;
//# sourceMappingURL=convert-legacy-tests-results-to-fix-entities.js.map