"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDisplayPath = void 0;
const pathLib = require("path");
const detect_1 = require("../../../lib/detect");
function getDisplayPath(path) {
    if (!detect_1.isLocalFolder(path)) {
        return path;
    }
    if (path === process.cwd()) {
        return pathLib.parse(path).name;
    }
    return pathLib.relative(process.cwd(), path);
}
exports.getDisplayPath = getDisplayPath;
//# sourceMappingURL=get-display-path.js.map