import { PerformanceAnalyticsKey } from './analytics';
declare type Awaited<T> = T extends PromiseLike<infer U> ? U : T;
export declare function asyncPerformanceAnalyticsDecorator<T extends (...args: any[]) => Promise<any>>(measurableMethod: T, analyticsKey: PerformanceAnalyticsKey): (...args: Parameters<T>) => Promise<Awaited<ReturnType<T>>>;
export declare function performanceAnalyticsDecorator<T extends (...args: any[]) => any>(measurableMethod: T, analyticsKey: PerformanceAnalyticsKey): (...args: Parameters<T>) => ReturnType<T>;
declare const measurableInitLocalCache: (__0?: {
    customRulesPath?: string | undefined;
} | undefined) => Promise<void>;
declare const measurableLoadFiles: (pathToScan: string, options?: import("./types").IaCTestFlags | undefined) => Promise<import("./types").IacFileData[]>;
declare const measurableParseFiles: (filesData: import("./types").IacFileData[], options?: import("./types").IaCTestFlags | undefined) => Promise<import("./types").ParsingResults>;
declare const measurableScanFiles: (parsedFiles: import("./types").IacFileParsed[]) => Promise<import("./types").IacFileScanResult[]>;
declare const measurableGetIacOrgSettings: (publicOrgId?: string | undefined) => Promise<import("./types").IacOrgSettings>;
declare const measurableApplyCustomSeverities: (scannedFiles: import("./types").IacFileScanResult[], customPolicies: Record<string, {
    severity?: string | undefined;
}>) => Promise<import("./types").IacFileScanResult[]>;
declare const measurableCleanLocalCache: () => void;
declare const measurableFormatScanResults: (scanResults: import("./types").IacFileScanResult[], options: import("./types").IaCTestFlags, meta: import("./types").TestMeta) => import("./types").FormattedResult[];
declare const measurableLocalTest: (pathToScan: string, options: import("./types").IaCTestFlags) => Promise<import("./types").TestReturnValue>;
export { measurableInitLocalCache as initLocalCache, measurableLoadFiles as loadFiles, measurableParseFiles as parseFiles, measurableScanFiles as scanFiles, measurableGetIacOrgSettings as getIacOrgSettings, measurableApplyCustomSeverities as applyCustomSeverities, measurableFormatScanResults as formatScanResults, measurableCleanLocalCache as cleanLocalCache, measurableLocalTest as localTest, };
