"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FailedToGetIacOrgSettingsError = exports.getIacOrgSettings = void 0;
const types_1 = require("../types");
const config = require("../../../../../lib/config");
const is_ci_1 = require("../../../../../lib/is-ci");
const api_token_1 = require("../../../../../lib/api-token");
const request = require("../../../../../lib/request");
const errors_1 = require("../../../../../lib/errors");
const error_utils_1 = require("../error-utils");
function getIacOrgSettings(publicOrgId) {
    const payload = {
        method: 'get',
        url: config.API + '/iac-org-settings',
        json: true,
        qs: { org: publicOrgId },
        headers: {
            'x-is-ci': is_ci_1.isCI(),
            authorization: `token ${api_token_1.api()}`,
        },
    };
    return new Promise((resolve, reject) => {
        request(payload, (error, res) => {
            if (error) {
                return reject(error);
            }
            if (res.statusCode < 200 || res.statusCode > 299) {
                return reject(new FailedToGetIacOrgSettingsError());
            }
            resolve(res.body);
        });
    });
}
exports.getIacOrgSettings = getIacOrgSettings;
class FailedToGetIacOrgSettingsError extends errors_1.CustomError {
    constructor(message) {
        super(message || 'Failed to fetch IaC organization settings');
        this.code = types_1.IaCErrorCodes.FailedToGetIacOrgSettingsError;
        this.strCode = error_utils_1.getErrorStringCode(this.code);
        this.userMessage =
            'We failed to fetch your organization settings, including custom severity overrides for infrastructure-as-code policies. Please run the command again with the `-d` flag and contact support@snyk.io with the contents of the output.';
    }
}
exports.FailedToGetIacOrgSettingsError = FailedToGetIacOrgSettingsError;
//# sourceMappingURL=get-iac-org-settings.js.map