"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthHeader = exports.apiOrOAuthTokenExists = exports.apiTokenExists = exports.getDockerToken = exports.getOAuthToken = exports.api = void 0;
const errors_1 = require("../lib/errors");
const config = require("./config");
const user_config_1 = require("./user-config");
function api() {
    // note: config.TOKEN will potentially come via the environment
    return config.api || config.TOKEN || user_config_1.config.get('api');
}
exports.api = api;
function getOAuthToken() {
    return process.env.SNYK_OAUTH_TOKEN;
}
exports.getOAuthToken = getOAuthToken;
function getDockerToken() {
    return process.env.SNYK_DOCKER_TOKEN;
}
exports.getDockerToken = getDockerToken;
function apiTokenExists() {
    const configured = api();
    if (!configured) {
        throw new errors_1.MissingApiTokenError();
    }
    return configured;
}
exports.apiTokenExists = apiTokenExists;
function apiOrOAuthTokenExists() {
    const oauthToken = getOAuthToken();
    if (oauthToken) {
        return oauthToken;
    }
    return apiTokenExists();
}
exports.apiOrOAuthTokenExists = apiOrOAuthTokenExists;
function getAuthHeader() {
    const oauthToken = getOAuthToken();
    const dockerToken = getDockerToken();
    if (oauthToken) {
        return `Bearer ${oauthToken}`;
    }
    if (dockerToken) {
        return `Bearer ${dockerToken}`;
    }
    return `token ${api()}`;
}
exports.getAuthHeader = getAuthHeader;
//# sourceMappingURL=api-token.js.map