"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSastSettingsForOrg = void 0;
const request = require("../../request");
const snyk = require("../..");
const config = require("../../config");
const common_1 = require("../../snyk-test/common");
async function getSastSettingsForOrg(org) {
    const response = await request({
        method: 'GET',
        headers: {
            Authorization: `token ${snyk.api}`,
        },
        qs: common_1.assembleQueryString({ org }),
        url: `${config.API}/cli-config/settings/sast`,
        gzip: true,
        json: true,
    });
    return response.body;
}
exports.getSastSettingsForOrg = getSastSettingsForOrg;
//# sourceMappingURL=settings.js.map