"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQueryParamsAsString = void 0;
/* eslint-disable @typescript-eslint/camelcase */
const url = require("url");
const os = require("os");
const is_docker_1 = require("./is-docker");
const analytics_sources_1 = require("./analytics-sources");
function getQueryParamsAsString(args) {
    var _a;
    const utm_source = process.env.SNYK_UTM_SOURCE || 'cli';
    const utm_medium = process.env.SNYK_UTM_MEDIUM || 'cli';
    const utm_campaign = process.env.SNYK_UTM_CAMPAIGN || analytics_sources_1.getIntegrationName(args) || 'cli';
    const utm_campaign_content = process.env.SNYK_UTM_CAMPAIGN_CONTENT || analytics_sources_1.getIntegrationVersion(args);
    const osType = (_a = os.type()) === null || _a === void 0 ? void 0 : _a.toLowerCase();
    const docker = is_docker_1.isDocker().toString();
    const queryParams = new url.URLSearchParams({
        utm_medium,
        utm_source,
        utm_campaign,
        utm_campaign_content,
        os: osType,
        docker,
    });
    // It may not be set and URLSearchParams won't filter out undefined values
    if (!utm_campaign_content) {
        queryParams.delete('utm_campaign_content');
    }
    return queryParams.toString();
}
exports.getQueryParamsAsString = getQueryParamsAsString;
//# sourceMappingURL=query-strings.js.map