"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStandaloneBuild = exports.getVersion = void 0;
const fs = require("fs");
const path = require("path");
const exec_1 = require("./exec");
async function getVersion() {
    const root = path.resolve(__dirname, '../..');
    const filename = path.resolve(root, 'package.json');
    const version = require(filename).version;
    if (version && version !== '0.0.0') {
        return version;
    }
    try {
        const [branchName, commitStr, filesCount] = await Promise.all([
            exec_1.executeCommand('git rev-parse HEAD', root),
            exec_1.executeCommand('git rev-parse --abbrev-ref HEAD', root),
            exec_1.executeCommand('git diff --shortstat', root),
        ]);
        const dirtyCount = parseInt(filesCount, 10) || 0;
        let curr = `${branchName}: ${commitStr}`;
        if (dirtyCount !== 0) {
            curr += ` (${dirtyCount} dirty files)`;
        }
        return curr;
    }
    catch (_err) {
        return 'unknown';
    }
}
exports.getVersion = getVersion;
function isStandaloneBuild() {
    const standalonePath = path.join(__dirname, '../', 'STANDALONE');
    return fs.existsSync(standalonePath);
}
exports.isStandaloneBuild = isStandaloneBuild;
//# sourceMappingURL=version.js.map