"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTargetFrameworksFromProjFile = void 0;
const errors_1 = require("../errors");
const fs = require("fs");
const path = require("path");
const parseXML = require("xml2js");
const debugModule = require("debug");
const framework_1 = require("./framework");
const debug = debugModule('snyk');
async function getTargetFrameworksFromProjFile(rootDir) {
    return new Promise((resolve, reject) => {
        debug('Looking for your .csproj file in ' + rootDir);
        const csprojPath = findFile(rootDir, /.*\.csproj$/);
        if (!csprojPath) {
            debug('.csproj file not found in ' + rootDir + '.');
            resolve(undefined);
            return;
        }
        debug('Checking .net framework version in .csproj file ' + csprojPath);
        const csprojContents = fs.readFileSync(csprojPath);
        let frameworks = [];
        parseXML.parseString(csprojContents, (err, parsedCsprojContents) => {
            var _a, _b, _c, _d, _e;
            if (err) {
                reject(new errors_1.FileNotProcessableError(err));
                return;
            }
            const versionLoc = (_b = (_a = parsedCsprojContents === null || parsedCsprojContents === void 0 ? void 0 : parsedCsprojContents.Project) === null || _a === void 0 ? void 0 : _a.PropertyGroup) === null || _b === void 0 ? void 0 : _b[0];
            const versions = []
                .concat((((_c = versionLoc === null || versionLoc === void 0 ? void 0 : versionLoc.TargetFrameworkVersion) === null || _c === void 0 ? void 0 : _c[0]) || ((_d = versionLoc === null || versionLoc === void 0 ? void 0 : versionLoc.TargetFramework) === null || _d === void 0 ? void 0 : _d[0]) || ((_e = versionLoc === null || versionLoc === void 0 ? void 0 : versionLoc.TargetFrameworks) === null || _e === void 0 ? void 0 : _e[0]) ||
                '').split(';'))
                .filter(Boolean);
            if (versions.length < 1) {
                debug('Could not find TargetFrameworkVersion/TargetFramework' +
                    '/TargetFrameworks defined in the Project.PropertyGroup field of ' +
                    'your .csproj file');
            }
            frameworks = versions.map(framework_1.toReadableFramework).filter(Boolean);
            if (versions.length > 1 && frameworks.length < 1) {
                debug('Could not find valid/supported .NET version in csproj file located at' +
                    csprojPath);
            }
            resolve(frameworks[0]);
        });
    });
}
exports.getTargetFrameworksFromProjFile = getTargetFrameworksFromProjFile;
function findFile(rootDir, filter) {
    if (!fs.existsSync(rootDir)) {
        throw new errors_1.FileNotFoundError('No such path: ' + rootDir);
    }
    const files = fs.readdirSync(rootDir);
    for (const file of files) {
        const filename = path.resolve(rootDir, file);
        if (filter.test(filename)) {
            return filename;
        }
    }
}
//# sourceMappingURL=csproj-parser.js.map