"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.jarFilesToScannedProjects = void 0;
const path = require("path");
function groupJarFingerprintsByPath(input) {
    const jarFingerprints = Object.entries(input).map(([filePath, digest]) => {
        return {
            location: filePath,
            digest,
        };
    });
    const resultAggregatedByPath = jarFingerprints.reduce((jarsAggregatedByPath, jarFingerprint) => {
        const location = path.dirname(jarFingerprint.location);
        jarsAggregatedByPath[location] = jarsAggregatedByPath[location] || [];
        jarsAggregatedByPath[location].push(jarFingerprint);
        return jarsAggregatedByPath;
    }, {});
    return resultAggregatedByPath;
}
async function jarFilesToScannedProjects(filePathToContent, targetImage) {
    const mappedResult = groupJarFingerprintsByPath(filePathToContent);
    const scanResults = [];
    for (const path in mappedResult) {
        if (!mappedResult.hasOwnProperty(path)) {
            continue;
        }
        const jarFingerprintsFact = {
            type: "jarFingerprints",
            data: {
                fingerprints: mappedResult[path],
                origin: targetImage,
                path,
            },
        };
        scanResults.push({
            facts: [jarFingerprintsFact],
            identity: {
                type: "maven",
                targetFile: path,
            },
        });
    }
    return scanResults;
}
exports.jarFilesToScannedProjects = jarFilesToScannedProjects;
//# sourceMappingURL=java.js.map