import { Dockerfile } from "dockerfile-ast";
import { DockerFileLayers, DockerFilePackages } from "./types";
export { getDockerfileBaseImageName, getLayersFromPackages, getPackagesFromDockerfile, instructionDigest, getPackagesFromRunInstructions, };
declare function getPackagesFromDockerfile(dockerfile: Dockerfile): DockerFilePackages;
declare function getPackagesFromRunInstructions(runInstructions: string[]): {};
/**
 * Return the image name of the last from stage, after resolving all aliases
 * @param dockerfile Dockerfile to use for retrieving the last stage image name
 */
declare function getDockerfileBaseImageName(dockerfile: Dockerfile): string | undefined;
declare function instructionDigest(instruction: any): string;
declare function getLayersFromPackages(dockerfilePkgs: DockerFilePackages): DockerFileLayers;
