"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fullImageSavePath = void 0;
const path = require("path");
const tmp = require("tmp");
const uuid_1 = require("uuid");
function fullImageSavePath(imageSavePath) {
    let imagePath = tmp.dirSync().name;
    if (imageSavePath) {
        imagePath = path.normalize(imageSavePath);
    }
    return path.join(imagePath, uuid_1.v4());
}
exports.fullImageSavePath = fullImageSavePath;
//# sourceMappingURL=image-save-path.js.map