"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getJarFileContentAction = void 0;
const path = require("path");
const stream_utils_1 = require("../../stream-utils");
const ignoredPaths = ["/usr/lib", "gradle/cache"];
function filePathMatches(filePath) {
    const dirName = path.dirname(filePath);
    return (filePath.endsWith(".jar") &&
        !ignoredPaths.some((ignorePath) => dirName.includes(path.normalize(ignorePath))));
}
exports.getJarFileContentAction = {
    actionName: "jar",
    filePathMatches,
    callback: stream_utils_1.streamToSha1,
};
//# sourceMappingURL=static.js.map