"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HashAlgorithm = exports.OsReleaseFilePath = exports.ImageType = void 0;
var ImageType;
(function (ImageType) {
    ImageType[ImageType["Identifier"] = 0] = "Identifier";
    ImageType["DockerArchive"] = "docker-archive";
    ImageType["OciArchive"] = "oci-archive";
})(ImageType = exports.ImageType || (exports.ImageType = {}));
var OsReleaseFilePath;
(function (OsReleaseFilePath) {
    OsReleaseFilePath["Linux"] = "/etc/os-release";
    OsReleaseFilePath["LinuxFallback"] = "/usr/lib/os-release";
    OsReleaseFilePath["Lsb"] = "/etc/lsb-release";
    OsReleaseFilePath["Debian"] = "/etc/debian_version";
    OsReleaseFilePath["Alpine"] = "/etc/alpine-release";
    OsReleaseFilePath["RedHat"] = "/etc/redhat-release";
    OsReleaseFilePath["Oracle"] = "/etc/oracle-release";
    OsReleaseFilePath["Centos"] = "/etc/centos-release";
})(OsReleaseFilePath = exports.OsReleaseFilePath || (exports.OsReleaseFilePath = {}));
var HashAlgorithm;
(function (HashAlgorithm) {
    HashAlgorithm["Sha256"] = "sha256";
    HashAlgorithm["Sha1"] = "sha1";
})(HashAlgorithm = exports.HashAlgorithm || (exports.HashAlgorithm = {}));
//# sourceMappingURL=types.js.map