"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const axios_1 = __importDefault(require("axios"));
const http_1 = __importDefault(require("http"));
const https_1 = __importDefault(require("https"));
const emitter_1 = __importDefault(require("./emitter"));
const agentOptions = {
    keepAlive: true,
    maxSockets: 100,
    maxFreeSockets: 10,
    freeSocketTimeout: 60000,
    socketActiveTTL: 1000 * 60 * 10,
    rejectUnauthorized: !global.ignoreUnknownCA,
};
const axios_ = axios_1.default.create({
    responseType: 'json',
    headers: {
        'Content-Type': 'application/json;charset=utf-8',
    },
    // keepAlive pools and reuses TCP connections, so it's faster
    httpAgent: new http_1.default.Agent(agentOptions),
    httpsAgent: new https_1.default.Agent(agentOptions),
    proxy: false,
});
axios_.interceptors.request.use((config) => {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
    const { method, url, data } = config;
    emitter_1.default.apiRequestLog(`=> HTTP ${method === null || method === void 0 ? void 0 : method.toUpperCase()} ${url} ${data ? JSON.stringify(data) : ''}`.slice(0, 399));
    return config;
}, (error) => {
    emitter_1.default.apiRequestLog(`Request error --> ${error.message}`);
    throw error;
});
axios_.interceptors.response.use((response) => {
    emitter_1.default.apiRequestLog(`<= Response: ${response.status} ${JSON.stringify(response.data)}`.slice(0, 399));
    return response;
}, (error) => {
    emitter_1.default.apiRequestLog(`Response error --> ${error.message}`);
    throw error;
});
exports.default = axios_;
//# sourceMappingURL=axios.js.map