---
title: Training
section: overview
---

import { Gallery, GalleryItem } from '@patternfly/react-core';
import { TrainingCard } from 'gatsby-theme-patternfly-org/components';

## Fundamentals

<Gallery gutter="md">
  <GalleryItem>
    <TrainingCard
      trainingType="html-css"
      title="The building blocks of PatternFly"
      level="beginner"
      time="20 minutes"
      description="Learn about components, layouts, and demos."
      katacodaId="building-blocks"
    />
  </GalleryItem>
  <GalleryItem>
    <TrainingCard
      trainingType="html-css"
      title="Variable naming principles"
      level="intermediate"
      time="20 minutes"
      description="Create and override component and global variables by following BEM naming principles."
      katacodaId="variable-naming-principles"
    />
  </GalleryItem>
  <GalleryItem>
    <TrainingCard
      trainingType="html-css"
      title="Modifiers and utilities"
      level="beginner"
      time="15 minutes"
      description="Apply modifier and utility classes to create new variations."
      katacodaId="modifier-utilities"
    />
  </GalleryItem>
  <GalleryItem>
    <TrainingCard
      trainingType="html-css"
      title="Layouts"
      level="beginner"
      time="25 minutes"
      description="Learn how to use all seven of PatternFly's layouts."
      katacodaId="layouts"
    />
  </GalleryItem>
  <GalleryItem>
    <TrainingCard
      trainingType="html-css"
      title="Override and extend variables"
      level="advanced"
      time="25 minutes"
      description="Practice overriding and extending variables to create new designs."
      katacodaId="override-extend-variables"
    />
  </GalleryItem>
</Gallery>