/**
 * LoadedPolicy is a wrapper around a WebAssembly.Instance and WebAssembly.Memory
 * for a compiled Rego policy. There are helpers to run the wasm instance and
 * handle the output from the policy wasm.
 */
declare class LoadedPolicy {
    /**
     * Loads and initializes a compiled Rego policy.
     * @param {WebAssembly.WebAssemblyInstantiatedSource} policy
     * @param {WebAssembly.Memory} memory
     */
    constructor(policy: WebAssembly.WebAssemblyInstantiatedSource, memory: WebAssembly.Memory);
    mem: WebAssembly.Memory;
    wasmInstance: WebAssembly.Instance | WebAssembly.WebAssemblyInstantiatedSource;
    dataAddr: number;
    baseHeapPtr: any;
    dataHeapPtr: any;
    /**
     * Evaluates the loaded policy with the given input and
     * return the result set. This should be re-used for multiple evaluations
     * of the same policy with different inputs.
     * @param {object} input
     */
    evaluate(input: object): any;
    /**
     * eval_bool will evaluate the policy and return a boolean answer
     * depending on the return code from the policy evaluation.
     * @deprecated Use `evaluate` instead.
     * @param {object} input
     */
    evalBool(input: object): boolean;
    /**
     * Loads data for use in subsequent evaluations.
     * @param {object} data
     */
    setData(data: object): void;
}
/**
 * Takes in either an ArrayBuffer or WebAssembly.Module
 * and will return a LoadedPolicy object which can be used to evaluate
 * the policy.
 * @param {BufferSource | WebAssembly.Module} regoWasm
 */
export declare function loadPolicy(regoWasm: ArrayBuffer | ArrayBufferView | WebAssembly.Module): Promise<LoadedPolicy>;
/**
 * Takes in either an ArrayBuffer or WebAssembly.Module
 * and will return a LoadedPolicy object which can be used to evaluate
 * the policy.
 * @param {BufferSource | WebAssembly.Module} regoWasm
 */
export declare function loadPolicy(regoWasm: ArrayBuffer | ArrayBufferView | WebAssembly.Module): Promise<LoadedPolicy>;
export {};
//# sourceMappingURL=opa.d.ts.map