"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.performanceAnalyticsObject = exports.PerformanceAnalyticsKey = exports.addIacAnalytics = void 0;
const analytics = require("../../../../lib/analytics");
function addIacAnalytics(formattedResults) {
    let totalIssuesCount = 0;
    const issuesByType = {};
    const packageManagers = Array();
    formattedResults.forEach((res) => {
        totalIssuesCount =
            (totalIssuesCount || 0) + res.result.cloudConfigResults.length;
        const packageManagerConfig = res.packageManager;
        packageManagers.push(packageManagerConfig);
        res.result.cloudConfigResults.forEach((policy) => {
            var _a;
            issuesByType[packageManagerConfig] = (_a = issuesByType[packageManagerConfig]) !== null && _a !== void 0 ? _a : {};
            issuesByType[packageManagerConfig][policy.severity] =
                (issuesByType[packageManagerConfig][policy.severity] || 0) + 1;
        });
    });
    analytics.add('packageManager', Array.from(new Set(packageManagers)));
    analytics.add('iac-issues-count', totalIssuesCount);
    analytics.add('iac-type', issuesByType);
    analytics.add('iac-metrics', exports.performanceAnalyticsObject);
    analytics.add('iac-test-count', formattedResults.length);
}
exports.addIacAnalytics = addIacAnalytics;
var PerformanceAnalyticsKey;
(function (PerformanceAnalyticsKey) {
    PerformanceAnalyticsKey["InitLocalCache"] = "cache-init-ms";
    PerformanceAnalyticsKey["FileLoading"] = "file-loading-ms";
    PerformanceAnalyticsKey["FileParsing"] = "file-parsing-ms";
    PerformanceAnalyticsKey["FileScanning"] = "file-scanning-ms";
    PerformanceAnalyticsKey["OrgSettings"] = "org-settings-ms";
    PerformanceAnalyticsKey["CustomSeverities"] = "custom-severities-ms";
    PerformanceAnalyticsKey["ResultFormatting"] = "results-formatting-ms";
    PerformanceAnalyticsKey["CacheCleanup"] = "cache-cleanup-ms";
    PerformanceAnalyticsKey["Total"] = "total-iac-ms";
})(PerformanceAnalyticsKey = exports.PerformanceAnalyticsKey || (exports.PerformanceAnalyticsKey = {}));
exports.performanceAnalyticsObject = {
    [PerformanceAnalyticsKey.InitLocalCache]: null,
    [PerformanceAnalyticsKey.FileLoading]: null,
    [PerformanceAnalyticsKey.FileParsing]: null,
    [PerformanceAnalyticsKey.FileScanning]: null,
    [PerformanceAnalyticsKey.OrgSettings]: null,
    [PerformanceAnalyticsKey.CustomSeverities]: null,
    [PerformanceAnalyticsKey.ResultFormatting]: null,
    [PerformanceAnalyticsKey.CacheCleanup]: null,
    [PerformanceAnalyticsKey.Total]: null,
};
//# sourceMappingURL=analytics.js.map