"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractLineNumber = void 0;
const types_1 = require("./types");
const errors_1 = require("../../../../lib/errors");
const cloud_config_parser_1 = require("@snyk/cloud-config-parser");
const file_parser_1 = require("./file-parser");
const analytics = require("../../../../lib/analytics");
const Debug = require("debug");
const error_utils_1 = require("./error-utils");
const debug = Debug('iac-extract-line-number');
function getFileTypeForLineNumber(fileType) {
    switch (fileType) {
        case 'yaml':
        case 'yml':
            return cloud_config_parser_1.CloudConfigFileTypes.YAML;
        case 'json':
            return cloud_config_parser_1.CloudConfigFileTypes.JSON;
        case 'tf':
            return cloud_config_parser_1.CloudConfigFileTypes.TF;
        default:
            throw new file_parser_1.UnsupportedFileTypeError(fileType);
    }
}
function extractLineNumber(scanResult, policy) {
    try {
        return cloud_config_parser_1.issuesToLineNumbers(scanResult.fileContent, getFileTypeForLineNumber(scanResult.fileType), policy.msg.split('.'));
    }
    catch (_a) {
        const err = new FailedToExtractLineNumberError();
        analytics.add('error-code', err.code);
        debug('Parser library failed. Could not assign lineNumber to issue');
        return -1;
    }
}
exports.extractLineNumber = extractLineNumber;
class FailedToExtractLineNumberError extends errors_1.CustomError {
    constructor(message) {
        super(message || 'Parser library failed. Could not assign lineNumber to issue');
        this.code = types_1.IaCErrorCodes.FailedToExtractLineNumberError;
        this.strCode = error_utils_1.getErrorStringCode(this.code);
        this.userMessage = ''; // Not a user facing error.
    }
}
//# sourceMappingURL=extract-line-number.js.map