"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractBundle = exports.createIacDir = void 0;
const fs = require("fs");
const tar = require("tar");
const path = require("path");
const local_cache_1 = require("./local-cache");
function createIacDir() {
    // this path will be able to be customised by the user in the future
    const iacPath = path.join('.iac-data/');
    try {
        if (!fs.existsSync(iacPath)) {
            fs.mkdirSync(iacPath, '700');
        }
        fs.accessSync(iacPath, fs.constants.W_OK);
    }
    catch (_a) {
        throw new local_cache_1.FailedToInitLocalCacheError();
    }
}
exports.createIacDir = createIacDir;
function extractBundle(response) {
    return new Promise((resolve, reject) => {
        response
            .on('error', reject)
            .pipe(tar.x({
            C: path.join('.iac-data'),
        }))
            .on('finish', resolve)
            .on('error', reject);
    });
}
exports.extractBundle = extractBundle;
//# sourceMappingURL=file-utils.js.map