"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.localTest = exports.cleanLocalCache = exports.formatScanResults = exports.applyCustomSeverities = exports.getIacOrgSettings = exports.scanFiles = exports.parseFiles = exports.loadFiles = exports.initLocalCache = exports.performanceAnalyticsDecorator = exports.asyncPerformanceAnalyticsDecorator = void 0;
const file_loader_1 = require("./file-loader");
const file_parser_1 = require("./file-parser");
const file_scanner_1 = require("./file-scanner");
const results_formatter_1 = require("./results-formatter");
const local_cache_1 = require("./local-cache");
const apply_custom_severities_1 = require("./org-settings/apply-custom-severities");
const get_iac_org_settings_1 = require("./org-settings/get-iac-org-settings");
const index_1 = require("./index");
const analytics_1 = require("./analytics");
// Note: The return type of the returned async function needs to be Promise<Val> for
// the compiler to be happy, so we need to unwrap it with the messy
// Awaiter<ReturnType<T>> rather than just using ReturnType<T> directly.
function asyncPerformanceAnalyticsDecorator(measurableMethod, analyticsKey) {
    return async function (...args) {
        const startTime = Date.now();
        const returnValue = await measurableMethod(...args);
        const durationMs = Date.now() - startTime;
        analytics_1.performanceAnalyticsObject[analyticsKey] = durationMs;
        return returnValue;
    };
}
exports.asyncPerformanceAnalyticsDecorator = asyncPerformanceAnalyticsDecorator;
function performanceAnalyticsDecorator(measurableMethod, analyticsKey) {
    return function (...args) {
        const startTime = Date.now();
        const returnValue = measurableMethod(...args);
        const durationMs = Date.now() - startTime;
        analytics_1.performanceAnalyticsObject[analyticsKey] = durationMs;
        return returnValue;
    };
}
exports.performanceAnalyticsDecorator = performanceAnalyticsDecorator;
const measurableInitLocalCache = asyncPerformanceAnalyticsDecorator(local_cache_1.initLocalCache, analytics_1.PerformanceAnalyticsKey.InitLocalCache);
exports.initLocalCache = measurableInitLocalCache;
const measurableLoadFiles = asyncPerformanceAnalyticsDecorator(file_loader_1.loadFiles, analytics_1.PerformanceAnalyticsKey.FileLoading);
exports.loadFiles = measurableLoadFiles;
const measurableParseFiles = asyncPerformanceAnalyticsDecorator(file_parser_1.parseFiles, analytics_1.PerformanceAnalyticsKey.FileParsing);
exports.parseFiles = measurableParseFiles;
const measurableScanFiles = asyncPerformanceAnalyticsDecorator(file_scanner_1.scanFiles, analytics_1.PerformanceAnalyticsKey.FileScanning);
exports.scanFiles = measurableScanFiles;
const measurableGetIacOrgSettings = asyncPerformanceAnalyticsDecorator(get_iac_org_settings_1.getIacOrgSettings, analytics_1.PerformanceAnalyticsKey.OrgSettings);
exports.getIacOrgSettings = measurableGetIacOrgSettings;
const measurableApplyCustomSeverities = asyncPerformanceAnalyticsDecorator(apply_custom_severities_1.applyCustomSeverities, analytics_1.PerformanceAnalyticsKey.CustomSeverities);
exports.applyCustomSeverities = measurableApplyCustomSeverities;
const measurableCleanLocalCache = performanceAnalyticsDecorator(local_cache_1.cleanLocalCache, analytics_1.PerformanceAnalyticsKey.CacheCleanup);
exports.cleanLocalCache = measurableCleanLocalCache;
const measurableFormatScanResults = performanceAnalyticsDecorator(results_formatter_1.formatScanResults, analytics_1.PerformanceAnalyticsKey.ResultFormatting);
exports.formatScanResults = measurableFormatScanResults;
const measurableLocalTest = asyncPerformanceAnalyticsDecorator(index_1.test, analytics_1.PerformanceAnalyticsKey.Total);
exports.localTest = measurableLocalTest;
//# sourceMappingURL=measurable-methods.js.map