"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyCustomSeverities = void 0;
const _ = require("lodash");
async function applyCustomSeverities(scannedFiles, customPolicies) {
    if (Object.keys(customPolicies).length > 0) {
        return scannedFiles.map((file) => {
            const updatedScannedFiles = _.cloneDeep(file);
            updatedScannedFiles.violatedPolicies.forEach((existingPolicy) => {
                var _a;
                const customPolicyForPublicID = customPolicies[existingPolicy.publicId];
                if (customPolicyForPublicID) {
                    existingPolicy.severity = (_a = customPolicyForPublicID.severity) !== null && _a !== void 0 ? _a : existingPolicy.severity;
                }
            });
            return updatedScannedFiles;
        });
    }
    return scannedFiles;
}
exports.applyCustomSeverities = applyCustomSeverities;
//# sourceMappingURL=apply-custom-severities.js.map