"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findAndLoadPolicyForScanResult = void 0;
const path = require("path");
const policy_1 = require("../policy");
async function findAndLoadPolicyForScanResult(scanResult, options) {
    const targetFileRelativePath = scanResult.identity.targetFile
        ? path.join(path.resolve(`${options.path}`), scanResult.identity.targetFile)
        : undefined;
    const targetFileDir = targetFileRelativePath
        ? path.parse(targetFileRelativePath).dir
        : undefined;
    const scanType = options.docker
        ? 'docker'
        : scanResult.identity.type;
    // TODO: fix this and send only send when we used resolve-deps for node
    // it should be a ExpandedPkgTree type instead
    const packageExpanded = undefined;
    const policy = (await policy_1.findAndLoadPolicy(options.path, scanType, options, packageExpanded, targetFileDir)); // TODO: findAndLoadPolicy() does not return a string!
    return policy;
}
exports.findAndLoadPolicyForScanResult = findAndLoadPolicyForScanResult;
//# sourceMappingURL=policy.js.map