"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gatherSpecs = exports.canHandle = void 0;
const path = require("path");
const try_get_spec_1 = require("./try-get-spec");
/* Supported example patterns:
 * Gemfile
 * Gemfile.lock
 * rails.2.4.5.gemfile
 * rails.2.4.5.gemfile.lock
 * gemfiles/Gemfile.rails-2.4.5.lock
 * gemfiles/Gemfile.lock.rails-2.4.5
 */
const gemfileOrLockfilePattern = /.*[gG]emfile.*(\.lock)?.*$/;
const gemfileLockPattern = /.*[gG]emfile.*(\.lock).*$/;
function canHandle(file) {
    return !!file && gemfileOrLockfilePattern.test(path.basename(file));
}
exports.canHandle = canHandle;
async function gatherSpecs(root, target) {
    const { dir, name } = path.parse(target);
    const isGemfileLock = gemfileLockPattern.test(target);
    // if the target is a Gemfile we treat is as the lockfile
    const gemfileLock = await try_get_spec_1.tryGetSpec(root, isGemfileLock ? target : path.join(target + '.lock'));
    if (gemfileLock) {
        return {
            packageName: path.basename(root),
            targetFile: path.join(dir, name),
            files: { gemfileLock },
        };
    }
    else {
        throw new Error(`Could not read ${target || 'Gemfile.lock'} lockfile: can't test ` +
            'without dependencies.\nPlease run `bundle install` first or' +
            ' if this is a custom file name re-run with --file=path/to/custom.gemfile.lock --package-manager=rubygems');
    }
}
exports.gatherSpecs = gatherSpecs;
//# sourceMappingURL=gemfile.js.map