"use strict";
const request = require("./request");
const alerts = require("../alerts");
const metrics_1 = require("../metrics");
async function requestWrapper(payload, callback) {
    const totalNetworkTimeTimer = metrics_1.MetricsCollector.NETWORK_TIME.createInstance();
    totalNetworkTimeTimer.start();
    try {
        const result = await request(payload);
        if (result.body.alerts) {
            alerts.registerAlerts(result.body.alerts);
        }
        // make callbacks and promises work
        if (callback) {
            callback(null, result.res, result.body);
        }
        return result;
    }
    catch (error) {
        if (callback) {
            return callback(error);
        }
        throw error;
    }
    finally {
        totalNetworkTimeTimer.stop();
    }
}
module.exports = requestWrapper;
//# sourceMappingURL=index.js.map