"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assembleIacLocalPayloads = exports.parseIacTestResult = void 0;
const fs = require("fs");
const path = require("path");
const pathUtil = require("path");
const snyk = require("..");
const is_ci_1 = require("../is-ci");
const common = require("./common");
const config = require("../config");
const legacy_1 = require("./legacy");
const pathLib = require("path");
const constants_1 = require("../iac/constants");
async function parseIacTestResult(res, targetFile, targetFileRelativePath, projectName, severityThreshold) {
    const meta = res.meta || {};
    severityThreshold =
        severityThreshold === legacy_1.SEVERITY.LOW ? undefined : severityThreshold;
    return Object.assign(Object.assign({}, res), { vulnerabilities: [], dependencyCount: 0, licensesPolicy: null, ignoreSettings: null, targetFile,
        projectName, org: meta.org, policy: meta.policy, isPrivate: !meta.isPublic, severityThreshold, targetFilePath: targetFileRelativePath });
}
exports.parseIacTestResult = parseIacTestResult;
async function assembleIacLocalPayloads(root, options) {
    const filesToTest = [];
    if (!options.iacDirFiles) {
        const fileType = pathLib.extname(root).substr(1);
        const targetFile = pathLib.resolve(root, '.');
        const targetFileRelativePath = targetFile
            ? pathUtil.join(pathUtil.resolve(`${options.path}`), targetFile)
            : '';
        filesToTest.push({
            fileType,
            fileName: root,
            filePath: targetFile,
            targetFileRelativePath,
        });
    }
    else {
        for (const iacFile of options.iacDirFiles) {
            if (iacFile.projectType) {
                const targetFile = iacFile.filePath;
                filesToTest.push({
                    fileType: iacFile.fileType,
                    fileName: path.basename(targetFile),
                    filePath: targetFile,
                    targetFileRelativePath: targetFile,
                });
            }
        }
    }
    return filesToTest.map((iacFileDetails) => {
        return assembleIacLocalPayload(iacFileDetails, options);
    });
}
exports.assembleIacLocalPayloads = assembleIacLocalPayloads;
function assembleIacLocalPayload(fileDetails, options) {
    const fileContent = fs.readFileSync(fileDetails.filePath, 'utf8');
    const projectType = constants_1.projectTypeByFileType[fileDetails.fileType];
    const body = {
        data: {
            fileContent,
            fileType: fileDetails.fileType,
        },
        targetFile: fileDetails.fileName,
        type: projectType,
        //TODO(orka): future - support policy
        policy: '',
        targetFileRelativePath: `${fileDetails.targetFileRelativePath}`,
        originalProjectName: path.basename(path.dirname(fileDetails.filePath)),
        projectNameOverride: options.projectName,
    };
    const payload = {
        method: 'POST',
        url: config.API + (options.vulnEndpoint || '/test-iac'),
        json: true,
        headers: {
            'x-is-ci': is_ci_1.isCI(),
            authorization: 'token ' + snyk.api,
        },
        qs: common.assembleQueryString(options),
        body,
    };
    return payload;
}
//# sourceMappingURL=run-iac-test.js.map