import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { Button } from '@patternfly/react-core/dist/js/components/Button';
import PencilAltIcon from '@patternfly/react-icons/dist/js/icons/pencil-alt-icon';
import CheckIcon from '@patternfly/react-icons/dist/js/icons/check-icon';
import TimesIcon from '@patternfly/react-icons/dist/js/icons/times-icon';
import inlineStyles from '@patternfly/react-styles/css/components/InlineEdit/inline-edit';
import classNames from 'classnames';
export const EditColumn = (_ref) => {
  let {
    onClick = null,

    /* eslint-disable @typescript-eslint/no-unused-vars */
    className = '',
    editing,
    valid,

    /* eslint-enable @typescript-eslint/no-unused-vars */
    saveAriaLabel,
    cancelAriaLabel,
    editAriaLabel
  } = _ref,
      props = _objectWithoutProperties(_ref, ["onClick", "className", "editing", "valid", "saveAriaLabel", "cancelAriaLabel", "editAriaLabel"]);

  return React.createElement(React.Fragment, null, React.createElement("div", {
    className: classNames(inlineStyles.inlineEditGroup, inlineStyles.modifiers.iconGroup, 'pf-m-action-group')
  }, React.createElement("div", {
    className: classNames(inlineStyles.inlineEditAction)
  }, React.createElement(Button, _extends({
    "aria-label": saveAriaLabel
  }, props, {
    onClick: e => onClick(e, 'save'),
    variant: "plain"
  }), React.createElement(CheckIcon, null))), React.createElement("div", {
    className: classNames(inlineStyles.inlineEditAction)
  }, React.createElement(Button, _extends({
    "aria-label": cancelAriaLabel
  }, props, {
    onClick: e => onClick(e, 'cancel'),
    variant: "plain"
  }), React.createElement(TimesIcon, null)))), React.createElement("div", {
    className: classNames(inlineStyles.inlineEditAction, inlineStyles.modifiers.enableEditable)
  }, React.createElement(Button, _extends({
    "aria-label": editAriaLabel
  }, props, {
    onClick: e => onClick(e, 'edit'),
    variant: "plain"
  }), React.createElement(PencilAltIcon, null))));
};
EditColumn.propTypes = {
  name: _pt.string,
  className: _pt.string,
  onClick: _pt.any,
  editing: _pt.bool,
  valid: _pt.bool,
  saveAriaLabel: _pt.string.isRequired,
  cancelAriaLabel: _pt.string.isRequired,
  editAriaLabel: _pt.string.isRequired
};
//# sourceMappingURL=EditColumn.js.map