import _pt from "prop-types";
import * as React from 'react';
import { TextInput } from '@patternfly/react-core/dist/js/components/TextInput';
import inlineStyles from '@patternfly/react-styles/css/components/InlineEdit/inline-edit';
import formStyles from '@patternfly/react-styles/css/components/Form/form';
import classNames from 'classnames'; // eslint-disable-next-line @typescript-eslint/interface-name-prefix

export const EditableTextCell = ({
  value,
  rowIndex,
  cellIndex,
  props,
  handleTextInputChange,
  inputAriaLabel,
  isDisabled
}) => React.createElement(React.Fragment, null, React.createElement("div", {
  className: inlineStyles.inlineEditValue
}, value), React.createElement("div", {
  className: inlineStyles.inlineEditInput
}, React.createElement(TextInput, {
  isDisabled: isDisabled,
  value: props.editableValue !== undefined ? props.editableValue : value,
  isValid: props.isValid,
  type: "text",
  onChange: (newValue, event) => {
    handleTextInputChange(newValue, event, rowIndex, cellIndex);
  },
  "aria-label": inputAriaLabel
}), React.createElement("div", {
  className: classNames(formStyles.formHelperText, formStyles.modifiers.error),
  "aria-live": "polite"
}, props.errorText)));
EditableTextCell.propTypes = {
  value: _pt.string.isRequired,
  rowIndex: _pt.number.isRequired,
  cellIndex: _pt.number.isRequired,
  props: _pt.any.isRequired,
  handleTextInputChange: _pt.func.isRequired,
  inputAriaLabel: _pt.string.isRequired,
  isDisabled: _pt.bool
};
//# sourceMappingURL=EditableTextCell.js.map