"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasFixableIssues = void 0;
function hasFixableIssues(results) {
    let hasFixes = false;
    let count = 0;
    for (const result of Object.values(results)) {
        const { remediation } = result;
        if (remediation) {
            const { upgrade, pin, patch } = remediation;
            const upgrades = Object.keys(upgrade);
            const pins = Object.keys(pin);
            if (pins.length || upgrades.length) {
                hasFixes = true;
                // pins & upgrades are mutually exclusive
                count += getUpgradableIssues(pins.length ? pin : upgrade);
            }
            const patches = Object.keys(patch);
            if (patches.length) {
                hasFixes = true;
                count += patches.length;
            }
        }
    }
    return {
        hasFixes,
        count,
    };
}
exports.hasFixableIssues = hasFixableIssues;
function getUpgradableIssues(updates) {
    const issues = [];
    for (const id of Object.keys(updates)) {
        issues.push(...updates[id].vulns);
    }
    return issues.length;
}
//# sourceMappingURL=fixable-issues.js.map