"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatDisplayName = void 0;
const pathLib = require("path");
function formatDisplayName(path, identity) {
    if (!identity.targetFile) {
        return `${identity.type} project`;
    }
    // show paths relative to where `snyk fix` is running
    return pathLib.relative(process.cwd(), pathLib.join(path, identity.targetFile));
}
exports.formatDisplayName = formatDisplayName;
//# sourceMappingURL=format-display-name.js.map