import { FixHandlerResultByPlugin } from '../../plugins/types';
import { ErrorsByEcoSystem } from '../../types';
export declare const PADDING_SPACE = "  ";
export declare function showResultsSummary(resultsByPlugin: FixHandlerResultByPlugin, exceptionsByScanType: ErrorsByEcoSystem): Promise<string>;
export declare function generateSuccessfulFixesSummary(resultsByPlugin: FixHandlerResultByPlugin): string;
export declare function generateUnresolvedSummary(resultsByPlugin: FixHandlerResultByPlugin, exceptionsByScanType: ErrorsByEcoSystem): {
    summary: string;
    count: number;
};
export declare function generateFixedAndFailedSummary(resultsByPlugin: FixHandlerResultByPlugin, exceptionsByScanType: ErrorsByEcoSystem): {
    summary: string;
    count: number;
};
export declare function calculateFixed(resultsByPlugin: FixHandlerResultByPlugin): number;
export declare function calculateFixedIssues(resultsByPlugin: FixHandlerResultByPlugin): number;
export declare function calculateFailed(resultsByPlugin: FixHandlerResultByPlugin, exceptionsByScanType: ErrorsByEcoSystem): number;
export declare function formatIssueCountBySeverity({ critical, high, medium, low, }: {
    [severity: string]: number;
}): string;
export declare const severitiesColourMapping: {
    [severity: string]: {
        colorFunc: (arg: string) => string;
    };
};
export declare const defaultSeverityColor: {
    colorFunc(text: any): string;
};
export declare function getSeveritiesColour(severity: string): {
    colorFunc: (arg: string) => string;
};
export declare function generateIssueSummary(resultsByPlugin: FixHandlerResultByPlugin, exceptionsByScanType: ErrorsByEcoSystem): string;
