"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateRequiredData = void 0;
const missing_remediation_data_1 = require("../../../lib/errors/missing-remediation-data");
const missing_file_name_1 = require("../../../lib/errors/missing-file-name");
const no_fixes_applied_1 = require("../../../lib/errors/no-fixes-applied");
function validateRequiredData(entity) {
    const { remediation } = entity.testResult;
    if (!remediation) {
        throw new missing_remediation_data_1.MissingRemediationDataError();
    }
    const { targetFile } = entity.scanResult.identity;
    if (!targetFile) {
        throw new missing_file_name_1.MissingFileNameError();
    }
    const { workspace } = entity;
    if (!workspace) {
        throw new no_fixes_applied_1.NoFixesCouldBeAppliedError();
    }
    return { targetFile, remediation, workspace };
}
exports.validateRequiredData = validateRequiredData;
//# sourceMappingURL=validate-required-data.js.map