"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadHandler = void 0;
const pip_requirements_1 = require("./handlers/pip-requirements");
const pipenv_pipfile_1 = require("./handlers/pipenv-pipfile");
const supported_handler_types_1 = require("./supported-handler-types");
function loadHandler(type) {
    switch (type) {
        case supported_handler_types_1.SUPPORTED_HANDLER_TYPES.REQUIREMENTS: {
            return pip_requirements_1.pipRequirementsTxt;
        }
        case supported_handler_types_1.SUPPORTED_HANDLER_TYPES.PIPFILE: {
            return pipenv_pipfile_1.pipenvPipfile;
        }
        default: {
            throw new Error('No handler available for requested project type');
        }
    }
}
exports.loadHandler = loadHandler;
//# sourceMappingURL=load-handler.js.map